<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/


namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}


use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Icon extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "icon";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[icon=\"icommon icon-home\" /]\n[icon icon=\"icommon icon-home\" flip=\"true\" spin=\"normal\" /]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "icon",
			"hint"		=> "icon class eg: \"icommon icon-home\""
		),
		
		array(
			"name"		=> "size",
			"hint"		=> "in px, default: 32"
		),

		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color",			
		),

		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode, default: transparent",			
		),

		array(
			"name"		=> "border",
			"hint"		=> "#hexcode, default: transparent",			
		),

		array(
			"name"		=> "radius",
			"hint"		=> "square|round|corners, default: square",			
		),

		array(
			"name"		=> "spin",
			"hint"		=> "normal|fast|slow, default: normal",			
		),

		array(
			"name"		=> "spin_dir",
			"hint"		=> "normal|reverse, default: normal",			
		),

		array(
			"name"		=> "rotate",
			"hint"		=> "0|90|180|270, default: 0",			
		),
		array(
			"name"		=> "flip",
			"hint"		=> "h|v|vh, default: none",			
		),
		array(
			"name"		=> "align",
			"hint"		=> "content|left|right, default: content",			
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),
	);
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars	= $data["vars"];
		$css	= array();
		$style	= array();
		$attr	= array();
		$icon	= $vars["attr"] ? $vars["attr"] : $vars["icon"];

		if (stristr($icon , "svgicon")) {
			$extra = $this->tpl->blockReplace(
				"SVG",
				array("attr"	=> trim(str_replace("svgicon" , "" , $icon)))
			);			
		}

		//simple
		if (isset($vars["attr"])) {
			return array(
				"content"	=> $this->tpl->blockReplace(
					"Simple" , 
					array(
						"icon"	=> $icon,
						"extra"	=> $extra
					)
				),
				"before"	=> "",
				"after"		=> "",
			);
		}

		if ($vars["size"]) {
			//$css["custom"]	= "icon-set-custom";
			$style[]		= "font-size: " . $vars["size"] . "px!important;";
			$attr[]			= "data-size=\"true\"";
		}
		
		if ($vars["spin"]) {
			switch ($vars["spin_dir"]) {
				default:		$css[] = "icon-set-spin"; break;
				case "reverse": $css[] = "icon-set-spin-reverse"; break;
			}			


			switch ($vars["spin"]) {
				case "fast": $css[] = "icon-set-spin-fast"; break;
				case "slow": $css[] = "icon-set-spin-slow";	break;
			}

		} else {

			if ($vars["rotate"]) {
				switch ($vars["rotate"]) {
					case "90":	$css[] = "icon-set-rotate-90"; break;
					case "180": $css[] = "icon-set-rotate-180"; break;
					case "270": $css[] = "icon-set-rotate-270"; break;
				}
			} 
		}

		if ($vars["bg"]) {
			$css["custom"]	= "icon-set-custom";
			$css[]			= "icon-set-bg";
			$style[]		= $this->getBackground($vars["bg"] , "background")["bg_style"];
		}

		if ($vars["color"]) {
			$style[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}

		if ($vars["border"]) {
			$css["custom"] = "icon-set-custom";
			$css[] = "icon-set-border";
			$style[] = $this->getBackground($vars["border"] , "border-color")["bg_style"];
		}

		if ($vars["flip"]) {
			switch ($vars["flip"]) {
				case "h":	$css[] = "icon-set-horizontal-flip"; break;
				case "v":	$css[] = "icon-set-vertical-flip"; break;
				case "vh":	$css[] = "icon-set-vertical-horizontal-flip"; break;
			}
		}

		if ($vars["radius"]) {
			switch ($vars["radius"]) {
				case "round":	
					$css["custom"] = "icon-set-custom";
					$css[] = "icon-set-radius-round"; 
				break;
				case "corners": 
					$css["custom"] = "icon-set-custom";
					$css[] = "icon-set-radius-corners"; 
				break;
			}
		} 

		if ($vars["align"]) {
			switch ($vars["align"]) {
				case "left":	
					$css[] = "icon-set-float-left"; 
				break;
				case "right": 
					$css[] = "icon-set-float-right"; 
				break;
			}
		} 
		
		if ($vars["class"]) { $css[] = $this->CSSClass($vars["class"]); }
		
		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				array(
					"icon"	=> $icon,
					"extra"	=> $extra,
					"css"	=> implode(" " , $css),
					"style"	=> implode(" " , $style),
					"attr"	=> implode(" " , $attr),
				)
			),
			"before"	=> "",
			"after"		=> "",
		);

	}
	
}